//pigasi
#declare pigfoot = cone {
	<0, 0, 0>, .5*inches
	<0, 6*inches, 0>, 2*inches
	scale <1, 1, .6>
}
#declare pigeye =  sphere {
	<4*inches, 0, 0>, .75*inches
	pigment {
		color Black
	}
}
#declare pigwing = cylinder {
	<0, -.1*inches, 0>, <0, .1*inches, 0>
	5*inches
	clipped_by { plane { z 0 } }
	scale <.75, 1, 3>
	rotate <90, 0, 0>
	translate <0, 4.5*inches, 0>
}

//creates a spring resting at y=0 and centered around the y axis.
#macro makeSpring (coilradius,wireradius,threadangle,coilheight)
	#local torushalf = torus {
		coilradius,
		wireradius
		clipped_by { plane {x 0} }
	}
	union {
		#local torusTranslation = coilradius*sin(radians(threadangle));
		#local currentTorus = 0;
		#while (2*currentTorus*torusTranslation < coilheight)
		object { torushalf
			#local theSign = pow(-1,currentTorus);
			scale <theSign,1,1>
			rotate <-theSign*threadangle,0,0>
			translate <0,2*currentTorus*torusTranslation,0>
		}
		#local currentTorus = currentTorus + 1;
		#end
	}
#end

#declare pigtail = object { makeSpring(.5*inches,.05*inches,8,3*inches)
	pigment {
		color rgb <0,1,0>
	}
}

#declare pigasi = union {
	//body
	union {
		//torso	
		sphere {
			<0, 0, 0>, 4*inches
			scale <3, 1, 1.5>
		}
		//head
		union {
			//skull
			union {
				sphere {
					<0, 0, 0>, 4*inches
				}
				//eyes
				object { pigeye
					rotate <0, 25, 0>
				}
				object { pigeye
					rotate <0, -25, 0>
				}
				scale <1, 1, 1.2>
			}
			//horn
			cone {
				<2.5*inches, 3*inches, 0>, 1*inches
				<7*inches, 9*inches, 0>,  0
				pigment {
					crackle
					color_map {
						[0.0 color Orange filter .5]
						[0.4 color Orange filter .1]
						[0.6 color Red filter .2]
						[1.0 color Red filter .6]
					}
					scale .03
				}
				finish {
					reflection 0.4
					specular 0.4
					roughness 0.2
				}
			}
			translate <12*inches, 3*inches, 0>
		}
		//wings
		object { pigwing
			rotate <70, 0, 0>
		}
		object { pigwing
			rotate <-70, 0, 0>
		}
		
		//tail
		object { pigtail
			rotate <0, 0, 70>
			scale <3, 1, 1>
			translate <-6.5*inches, -.5*inches, 0>
		}
		
		translate <0, 8*inches, 0>
		rotate <0, 0, 5>
	}
	object { pigfoot
		translate <-5*inches, 0, -3*inches>
	}
	object { pigfoot
		translate <-5*inches, 0, 3*inches>
	}
	object { pigfoot
		translate <4*inches, 0, -3*inches>
	}
	object { pigfoot
		translate <4*inches, 0, 3*inches>
	}
	
	pigment {
		bozo
		color_map {
			[0.0 color Pink]
			[0.25 color Pink]
			[0.50 color Green]
			[0.6 color Green]
			[1.0 color Pink]
		}
		scale .05
	}
	finish {
		reflection 0.1
		specular 0.4
		roughness 0.2
	}
}
